/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskPortAvail
extends Task {
    private String m_component = null;
    private Hashtable<String, List<NetworkConstants.NetworkProtocol>> m_PortListToCheckOnALLNetworks = new Hashtable();
    private Hashtable<String, List<NetworkConstants.NetworkProtocol>> m_PortListToCheckOnPublicNetworks = new Hashtable();
    private Hashtable<String, List<NetworkConstants.NetworkProtocol>> m_PortListToCheckOnPrivateNetworks = new Hashtable();
    private boolean isHeaderPrinted = false;
    private static Hashtable<String, String> m_resolvablePortComponentVariableNameTable = new Hashtable();

    public static String resolvePortNumber(String component, String defaultPortNumber) {
        if (m_resolvablePortComponentVariableNameTable.containsKey(component)) {
            String installerVarName = m_resolvablePortComponentVariableNameTable.get(component);
            String dynamicPortNumber = VerificationUtil.getVariableValue(installerVarName);
            if (VerificationUtil.isStringGood(dynamicPortNumber)) {
                Trace.out((String)("The installer variable " + installerVarName + " is set for dynamically selected port number of component " + component + " The dynamically set value is " + dynamicPortNumber));
                VerificationLogData.logFine("The installer variable " + installerVarName + " is set for dynamically selected port number of component " + component + " The dynamically set value is " + dynamicPortNumber);
                return dynamicPortNumber;
            }
            Trace.out((String)("The installer variable " + installerVarName + " was not found set for dynamic selection of port number for component " + component + " hence returning the default port number " + defaultPortNumber));
            VerificationLogData.logFine("The installer variable " + installerVarName + " was not found set for dynamic selection of port number for component " + component + " hence returning the default port number " + defaultPortNumber);
            return defaultPortNumber;
        }
        Trace.out((String)("The component " + component + " does not have installer variable assigned to read " + "the dynamic port number setting, Hence returning default port number " + defaultPortNumber));
        VerificationLogData.logFine("The component " + component + " does not have installer variable assigned to read " + "the dynamic port number setting, Hence returning default port number " + defaultPortNumber);
        return defaultPortNumber;
    }

    public TaskPortAvail(String[] nodeList, String componentName, HashMap<String, HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType>> portProtocolMap) {
        super(nodeList, null, 1);
        this.setPorts(componentName, portProtocolMap);
    }

    public void setPorts(String componentName, HashMap<String, HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType>> portProtocolMap) {
        this.m_component = componentName;
        if (null != portProtocolMap && portProtocolMap.size() > 0) {
            for (String port : portProtocolMap.keySet()) {
                for (NetworkConstants.NetworkProtocol protocol : portProtocolMap.get(port).keySet()) {
                    ArrayList<NetworkConstants.NetworkProtocol> protoList;
                    NetworkConstants.NetworkType netWorkType = portProtocolMap.get(port).get((Object)protocol);
                    if (netWorkType == NetworkConstants.NetworkType.ALL) {
                        if (this.m_PortListToCheckOnALLNetworks.containsKey(port)) {
                            if (this.m_PortListToCheckOnALLNetworks.get(port).contains((Object)protocol)) continue;
                            this.m_PortListToCheckOnALLNetworks.get(port).add(protocol);
                            continue;
                        }
                        protoList = new ArrayList<NetworkConstants.NetworkProtocol>();
                        protoList.add(protocol);
                        this.m_PortListToCheckOnALLNetworks.put(port, protoList);
                        continue;
                    }
                    if (netWorkType == NetworkConstants.NetworkType.PUBLIC) {
                        if (this.m_PortListToCheckOnPublicNetworks.containsKey(port)) {
                            if (this.m_PortListToCheckOnPublicNetworks.get(port).contains((Object)protocol)) continue;
                            this.m_PortListToCheckOnPublicNetworks.get(port).add(protocol);
                            continue;
                        }
                        protoList = new ArrayList();
                        protoList.add(protocol);
                        this.m_PortListToCheckOnPublicNetworks.put(port, protoList);
                        continue;
                    }
                    if (netWorkType == NetworkConstants.NetworkType.PRIVATE) {
                        if (this.m_PortListToCheckOnPrivateNetworks.containsKey(port)) {
                            if (this.m_PortListToCheckOnPrivateNetworks.get(port).contains((Object)protocol)) continue;
                            this.m_PortListToCheckOnPrivateNetworks.get(port).add(protocol);
                            continue;
                        }
                        protoList = new ArrayList();
                        protoList.add(protocol);
                        this.m_PortListToCheckOnPrivateNetworks.put(port, protoList);
                        continue;
                    }
                    Trace.out((String)("Skipped port (" + port + "): Incorrect network type for port " + port + " network type " + (Object)((Object)netWorkType) + " not supported"));
                    VerificationLogData.logWarning("Skipped port (" + port + "): Incorrect network type for port " + port + " network type " + (Object)((Object)netWorkType) + " not supported");
                }
            }
        } else {
            Trace.out((String)"Port list not supplied for verification.");
            VerificationLogData.logWarning("Port list not supplied for verification.");
        }
    }

    @Override
    public boolean performTask() {
        ArrayList<String> portList = new ArrayList<String>();
        portList.addAll(this.m_PortListToCheckOnALLNetworks.keySet());
        portList.addAll(this.m_PortListToCheckOnPublicNetworks.keySet());
        portList.addAll(this.m_PortListToCheckOnPrivateNetworks.keySet());
        Trace.out((String)("Performing Port Availability Verification Task for component " + this.m_component + " and ports " + VerificationUtil.strCollection2String(portList) + " on nodes (" + VerificationUtil.strArr2List(this.m_nodeList) + ")"));
        VerificationLogData.log("Validating Port Availability for component " + this.m_component + " and ports " + VerificationUtil.strCollection2String(portList) + " on nodes (" + VerificationUtil.strArr2List(this.m_nodeList) + ")");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4650", false, (Object[])new String[]{VerificationUtil.strCollection2String(portList), this.m_component}));
        ArrayList<String> failedPorts = new ArrayList<String>();
        ArrayList<String> succPorts = new ArrayList<String>();
        if (this.m_PortListToCheckOnALLNetworks.size() > 0) {
            this.verifyPorts(NetworkConstants.NetworkType.ALL, failedPorts, succPorts);
        }
        if (this.m_PortListToCheckOnPublicNetworks.size() > 0) {
            this.verifyPorts(NetworkConstants.NetworkType.PUBLIC, failedPorts, succPorts);
        }
        if (this.m_PortListToCheckOnPrivateNetworks.size() > 0) {
            this.verifyPorts(NetworkConstants.NetworkType.PRIVATE, failedPorts, succPorts);
        }
        for (String node : this.m_nodeList) {
            Result nodeResult = this.m_resultSet.getResult(node);
            if (nodeResult.getStatus() != 2) continue;
            String errMsg = "";
            for (VerificationError error : nodeResult.getErrors()) {
                errMsg = errMsg + (VerificationUtil.isStringGood(errMsg) ? LSEP : "");
                errMsg = errMsg + error.getErrorMessage();
            }
            if (!VerificationUtil.isStringGood(errMsg)) continue;
            ReportUtil.printError(errMsg);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("4653", false, (Object[])new String[]{VerificationUtil.strCollection2String(portList)}));
            return true;
        }
        String resultMessage = "";
        if (!succPorts.isEmpty()) {
            resultMessage = s_msgBundle.getMessage("4653", false, (Object[])new String[]{VerificationUtil.strList2List(succPorts)});
        }
        if (!failedPorts.isEmpty()) {
            resultMessage = resultMessage + (VerificationUtil.isStringGood(resultMessage) ? LSEP : "");
            resultMessage = resultMessage + s_msgBundle.getMessage("4654", false, (Object[])new String[]{VerificationUtil.strList2List(failedPorts)});
        }
        ReportUtil.printResult(resultMessage);
        ReportUtil.printErrorNodes(this.m_resultSet.getFailureNodes());
        return false;
    }

    private void verifyPorts(NetworkConstants.NetworkType netWorkType, List<String> failedPorts, List<String> succPorts) {
        if (!this.isHeaderPrinted) {
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.PORT_NUMBER, ReportUtil.PROTOCOL, ReportUtil.AVAILABLE, ReportUtil.STATUS);
        }
        this.isHeaderPrinted = true;
        ArrayList<String> subNetAddressList = null;
        Hashtable<String, List<NetworkConstants.NetworkProtocol>> portTable = null;
        ResultSet subnetRetResSet = new ResultSet();
        switch (netWorkType) {
            case ALL: {
                portTable = this.m_PortListToCheckOnALLNetworks;
                subNetAddressList = new ArrayList();
                subnetRetResSet.addResult(this.m_nodeList, 1);
                break;
            }
            case PUBLIC: {
                portTable = this.m_PortListToCheckOnPublicNetworks;
                subNetAddressList = NetworkUtility.getClassifiedSubnetList(this.m_nodeList, subnetRetResSet, false);
                break;
            }
            case PRIVATE: {
                portTable = this.m_PortListToCheckOnPrivateNetworks;
                subNetAddressList = NetworkUtility.getClassifiedSubnetList(this.m_nodeList, subnetRetResSet, true);
            }
        }
        if (subnetRetResSet.allSuccess()) {
            Trace.out((String)("BEGIN :- Verifying ports (" + VerificationUtil.strCollection2String(portTable.keySet()) + ") on " + netWorkType.toString() + " networks"));
            VerificationLogData.logInfo("Verifying ports (" + VerificationUtil.strCollection2String(portTable.keySet()) + ") on " + netWorkType.toString() + " networks");
            GlobalExecution globalExec = new GlobalExecution();
            for (String port : portTable.keySet()) {
                for (NetworkConstants.NetworkProtocol protocol : portTable.get(port)) {
                    ResultSet checkPortResultSet = new ResultSet();
                    globalExec.checkPort(this.m_nodeList, subNetAddressList, port, protocol, checkPortResultSet);
                    ErrorDescription errDesc = null;
                    Hashtable ht = checkPortResultSet.getResultTable();
                    Enumeration e = ht.keys();
                    String portStatus = ReportUtil.UNKNOWN;
                    String nodeStatus = ReportUtil.UNKNOWN;
                    ArrayList<String> verificationFailedNodeList = new ArrayList<String>();
                    ArrayList<String> operationFailedNodeList = new ArrayList<String>();
                    while (e.hasMoreElements()) {
                        String node = (String)e.nextElement();
                        checkPortResultSet.getResult(node).setHasResultValues(true);
                        checkPortResultSet.getResult(node).setExpectedValue(ReportUtil.AVAILABLE);
                        Result result = (Result)ht.get(node);
                        if (result.getStatus() == 3) {
                            portStatus = ReportUtil.NO;
                            errDesc = new ErrorDescription(s_gMsgBundle.getMessage("0330", true, (Object[])new String[]{protocol.toString(), port, this.m_component, node}));
                            checkPortResultSet.addErrorDescription(node, errDesc);
                            nodeStatus = ReportUtil.FAILED;
                            Trace.out((String)("Port " + port + " Required for " + this.m_component + "  found busy and used on node " + node));
                            VerificationLogData.logInfo("Port " + port + " Requried for " + this.m_component + "  found busy and used on node " + node);
                            failedPorts.add(port);
                            verificationFailedNodeList.add(node);
                            checkPortResultSet.getResult(node).setActualValue(ReportUtil.USED);
                        } else if (result.getStatus() == 1) {
                            portStatus = ReportUtil.YES;
                            nodeStatus = ReportUtil.SUCCESSFUL;
                            Trace.out((String)("Port " + port + " Required for " + this.m_component + " is available on node " + node));
                            VerificationLogData.logInfo("Port " + port + " Requried for " + this.m_component + " is available on node " + node);
                            checkPortResultSet.getResult(node).setActualValue(ReportUtil.AVAILABLE);
                        } else {
                            portStatus = ReportUtil.UNKNOWN;
                            errDesc = new ErrorDescription(s_gMsgBundle.getMessage("0329", true, (Object[])new String[]{protocol.toString(), port, node}));
                            checkPortResultSet.addErrorDescription(node, errDesc);
                            nodeStatus = ReportUtil.FAILED;
                            Trace.out((String)("Port " + port + " Required for " + this.m_component + " could not be checked on node " + node));
                            VerificationLogData.logInfo("Port " + port + " Requried for " + this.m_component + " could not be checked on node " + node);
                            failedPorts.add(port);
                            operationFailedNodeList.add(node);
                            checkPortResultSet.getResult(node).setActualValue(ReportUtil.UNKNOWN);
                        }
                        ReportUtil.writeRecord(node, port, protocol.toString(), portStatus, nodeStatus);
                    }
                    if (verificationFailedNodeList.size() > 0) {
                        errDesc = new ErrorDescription(s_gMsgBundle.getMessage("0330", true, (Object[])new String[]{protocol.toString(), port, this.m_component, VerificationUtil.strCollection2String(verificationFailedNodeList)}));
                        checkPortResultSet.addErrorDescription(errDesc);
                    }
                    if (operationFailedNodeList.size() > 0) {
                        errDesc = new ErrorDescription(s_gMsgBundle.getMessage("0329", true, (Object[])new String[]{protocol.toString(), port, VerificationUtil.strCollection2String(operationFailedNodeList)}));
                        checkPortResultSet.addErrorDescription(errDesc);
                    }
                    this.m_resultSet.uploadResultSet(checkPortResultSet);
                }
                if (failedPorts.contains(port)) continue;
                succPorts.add(port);
            }
            Trace.out((String)("END :- Verification of ports (" + VerificationUtil.strCollection2String(portTable.keySet()) + ") on " + netWorkType.toString() + " networks complete."));
        } else {
            Trace.out((String)("Failed to retrieve subnet list for " + netWorkType.toString() + " networks, Not Verifying ports (" + VerificationUtil.strCollection2String(portTable.keySet()) + ")"));
            VerificationLogData.logInfo("Failed to retrieve subnet list for " + netWorkType.toString() + " networks, Not Verifying ports (" + VerificationUtil.strCollection2String(portTable.keySet()) + ")");
            this.m_resultSet.uploadResultSet(subnetRetResSet);
            failedPorts.addAll(portTable.keySet());
        }
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4434", false, (Object[])new String[]{this.m_component});
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4485", false, (Object[])new String[]{this.m_component});
    }

    static {
        m_resolvablePortComponentVariableNameTable.put(PortComponentNames.DB_LISTENER, "SCAN_PORT");
    }

    public static class PortComponentNames {
        public static String OC4J = "Oracle Containers for J2EE (OC4J)";
        public static String ORMI = "Oracle Remote Method Invocation (ORMI)";
        public static String ONS = "Oracle Notification Service (ONS)";
        public static String DB_LISTENER = "Oracle Database Listener";
        public static String ONS_FOR_EM = "Oracle Notification Service (ONS) Enterprise Manager support";
    }
}

